/*
**
** Copyright 2017, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#ifndef SOFTWARE_CONTEXT_SOFT_ATTESTATION_CERT_H_
#define SOFTWARE_CONTEXT_SOFT_ATTESTATION_CERT_H_

#include <hardware/keymaster_defs.h>
#include <keymaster/android_keymaster_utils.h>

namespace keymaster {

const keymaster_key_blob_t* getAttestationKey(keymaster_algorithm_t algorithm,
                                              keymaster_error_t* error);
CertificateChain getAttestationChain(keymaster_algorithm_t algorithm, keymaster_error_t* error);

}  // namespace keymaster
#endif  // SOFTWARE_CONTEXT_SOFT_ATTESTATION_CERT_H_
