/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

namespace keymaster {

// kKmDate is the date that KM was last modified.  Ideally it should be changed every time
// there's a significant change in the implementation, and it should be set to the date that
// the change is merged into AOSP.
//
// TODO(swillden): Look into how to create a commit hook to update this.
constexpr uint32_t kKmDate = 20201219;

}  // namespace keymaster
